/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageLabel
extends Canvas {
    protected Image image;
    public static String defaultImageString = "";
    protected String imageString = "<Existing Image>";
    public boolean debug = false;
    protected int margin;
    protected Color marginColor;
    protected int width;
    protected int height;
    protected boolean explicitSize = false;
    private int explicitWidth;
    private int explicitHeight;
    private MediaTracker tracker;
    private static int lastTrackerID;
    private int currentTrackerID;
    private boolean doneLoading = false;
    private Container parentContainer;

    public ImageLabel() {
        this(defaultImageString);
    }

    public ImageLabel(String string) {
        this(ImageLabel.makeURL(string));
    }

    public ImageLabel(URL uRL) {
        this(ImageLabel.getImage(uRL));
        this.imageString = uRL.toExternalForm();
    }

    public ImageLabel(Image image) {
        this.debug("[ImageLabel] - entering constructor");
        this.image = image;
        this.tracker = new MediaTracker(this);
        this.currentTrackerID = lastTrackerID++;
        this.tracker.addImage(image, this.currentTrackerID);
        this.debug("[ImageLabel] - leaving constructor");
    }

    public void waitForImage(boolean bl) {
        this.debug("[waitForImage] - Enter ...");
        if (!this.doneLoading) {
            this.debug("[waitForImage] - Resizing and waiting for " + this.imageString);
            try {
                this.tracker.waitForID(this.currentTrackerID);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                System.out.println("Error loading " + this.imageString + ": " + exception.getMessage());
                exception.printStackTrace();
            }
            if (this.tracker.isErrorID(0)) {
                new Throwable("Error loading image " + this.imageString).printStackTrace();
            }
            this.doneLoading = true;
            this.width = this.explicitWidth != 0 ? this.explicitWidth : this.image.getWidth(this) + 2 * this.margin;
            this.height = this.explicitHeight != 0 ? this.explicitHeight : this.image.getHeight(this) + 2 * this.margin;
            this.setSize(this.width, this.height);
            this.debug("[waitForImage] - " + this.imageString + " is " + this.width + "x" + this.height + ".");
            this.parentContainer = this.getParent();
            if (this.parentContainer != null && bl) {
                this.setBackground(this.parentContainer.getBackground());
            }
        }
        this.debug("[waitForImage] - Exit ...");
    }

    public void centerAt(int n, int n2) {
        this.debug("Placing center of " + this.imageString + " at (" + n + "," + n2 + ")");
        this.setLocation(n - this.width / 2, n2 - this.height / 2);
    }

    public synchronized boolean contains(int n, int n2) {
        return n >= 0 && n <= this.width && n2 >= 0 && n2 <= this.height;
    }

    public void paint(Graphics graphics) {
        this.debug("Entering paint() in ImageLabel");
        if (!this.doneLoading) {
            this.waitForImage(true);
        } else {
            if (this.explicitSize) {
                graphics.drawImage(this.image, this.margin, this.margin, this.width - 2 * this.margin, this.height - 2 * this.margin, this);
            } else {
                graphics.drawImage(this.image, this.margin, this.margin, this);
            }
            this.drawRect(graphics, 0, 0, this.width - 1, this.height - 1, this.margin, this.marginColor);
        }
        this.debug("Exiting paint() in ImageLabel");
    }

    public Dimension getPreferredSize() {
        if (!this.doneLoading) {
            this.waitForImage(false);
        }
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (!this.doneLoading) {
            this.waitForImage(false);
        }
        return super.getMinimumSize();
    }

    public void setSize(int n, int n2) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (n > 0) {
                this.explicitWidth = n;
            }
            if (n2 > 0) {
                this.explicitHeight = n2;
            }
        }
        super.setSize(n, n2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            this.explicitWidth = n3;
            this.explicitHeight = n4;
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void drawRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
        graphics.setColor(color);
        int n6 = 0;
        while (n6 < n5) {
            graphics.drawRect(n, n2, n3, n4);
            if (n6 < n5 - 1) {
                ++n;
                ++n2;
                n3 -= 2;
                n4 -= 2;
            }
            ++n6;
        }
    }

    protected void debug(String string) {
        if (this.debug) {
            System.err.println(string);
        }
    }

    private static URL makeURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Bad URL " + string + ": " + malformedURLException);
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    private static Image getImage(URL uRL) {
        return Toolkit.getDefaultToolkit().getImage(uRL);
    }

    public void update(Graphics graphics) {
    }
}

